#!/bin/sh

# Check parameter number
if [ $# -gt 0 ]; then

	# Find connect_gateway.sh path (different on MS and SC)
	connect_gateway_file_path=`find /opt -name connect_gateway.sh`
	
	# Query current internet status
	internet_connected=`$connect_gateway_file_path /query.sh --role WILD --enabled`	
	
	if [ "$1" = "-enable" ]; then
	
		if [ "$internet_connected" = "true" ]; then
			echo "Internet connection is already enabled."
		else
			$connect_gateway_file_path /setup.sh --role WILD --enable
			echo "Internet connection is enabled."
		fi
		
		exit
		
	elif [ "$1" = "-disable" ]; then

		if [ "$internet_connected" = "false" ]; then
			echo "Internet connection is already disabled."
		else
			$connect_gateway_file_path /setup.sh --role WILD --disable
			echo "Internet connection is disabled."
		fi
		
		exit
		
	elif [ "$1" = "-status" ]; then
	
		if [ "$internet_connected" = "true" ]; then
			echo "enabled"
		else
			echo "disabled"
		fi
		
		exit
	fi
		
fi

echo "$0 [<switches>]"
echo ""
echo "Switches:"
echo "  -enable     Enable Internet connection"
echo "  -disable    Disable Internet connection"
echo "  -status     Check current Internet connection status"
echo "";